/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.events.*;

public class Slider extends Control {
	int minimum, maximum, selection, thumb, increment, pageIncrement;

public Slider (Composite parent, int style) {
	super (parent, style);
}

public void addSelectionListener (SelectionListener listener) {
	checkWidget();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	TypedListener typedListener = new TypedListener(listener);
	addListener (SWT.Selection,typedListener);
	addListener (SWT.DefaultSelection,typedListener);
}

void createWidget(Display display, Widget parent, int style, int index) {
	super.createWidget (display, parent, style, index);
	setValues (0, 0, 100, 10, 1, 10);
}

public int getIncrement () {
	checkWidget ();
	return increment;
}

public int getMaximum () {
	checkWidget ();
	return maximum;
}

public int getMinimum () {
	checkWidget ();
	return minimum;
}

public int getPageIncrement () {
	checkWidget ();
	return pageIncrement;
}

public int getSelection () {
	checkWidget ();
	return selection;
}

public int getThumb () {
	checkWidget ();
	return thumb;
}

public void removeSelectionListener (SelectionListener listener) {
	checkWidget();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (eventTable == null) return;
	eventTable.unhook (SWT.Selection, listener);
	eventTable.unhook (SWT.DefaultSelection,listener);	
}

void sendSelection (int detail, int selection) {
	this.selection = selection;
	Event event = new Event ();
	event.detail = detail;
	sendEvent (SWT.Selection, event);
}

public void setIncrement (int value) {
	setValues(selection, minimum, maximum, thumb, value, pageIncrement);
}

public void setMaximum (int value) {
	setValues(selection, minimum, value, thumb, increment, pageIncrement);
}

public void setMinimum (int value) {
	setValues(selection, value, maximum, thumb, increment, pageIncrement);
}

public void setPageIncrement (int value) {
	setValues(selection, minimum, maximum, thumb, increment, value);
}

public void setSelection (int value) {
	setValues(value, minimum, maximum, thumb, increment, pageIncrement);
}

public void setThumb (int value) {
	setValues(selection, minimum, maximum, value, increment, pageIncrement);
}

public void setValues (int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
	checkWidget();
	if (minimum < 0) return;
	if (maximum < 0) return;
	if (thumb < 1) return;
	if (increment < 1) return;
	if (pageIncrement < 1) return;
	//TODO - more range checks
	this.selection = selection;
	this.minimum = minimum;
	this.maximum = maximum;
	this.thumb = thumb;
	this.increment = increment;
	this.pageIncrement = pageIncrement;
	_setValues (selection, minimum, maximum, thumb, increment, pageIncrement);
}

/*---------------- COMMON INTERFACE ----------------*/

void _setValues (int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
	Object[] args = new Object[]{
		new Integer(selection),
		new Integer(minimum),
		new Integer(maximum),
		new Integer(thumb),
		new Integer(increment),
		new Integer(pageIncrement),
	};
	callMethod("_setValues", null, args);
}
}
